 ; Ŀ
 ;   Flipper - find a space in a drawing suitable for a permit stamp.      
 ;   Copyright 1996, 2010 by Rocket Software Ltd.                          
 ;   Once you write a program with common sense, it isn't just possible    
 ;   to use it instead of a person, it's mandatory.                        
 ; 

 ; Ŀ
 ;   Subroutine Elel - Find the lower left corner of a box.                
 ;   Takes one argument: a list of two corner points.                      
 ; 
 (DEFUN ELEL (pa / x1 x2 y1 y2 pax pay)
  (setq x1 (caar pa))
  (setq x2 (caadr pa))
  (setq y1 (cadar pa))
  (setq y2 (cadadr pa))
  (if (> x1 x2)
      (setq pax x2)
      (setq pax x1))
  (if (> y1 y2)
      (setq pay y2)
      (setq pay y1))
  (list pax pay))
 ; Ŀ
 ;   Elel end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Feel - search an area.                                     
 ;   Arguments:     Pa: Search start point                                 
 ;               Gzero: base point from which pa is an offset              
 ;               Areax: Search area X width (+ or -)                       
 ;               Areay: Search area Y height (+ or -)                      
 ;                Sdir: Move search box first in X or Y direction          
 ;              Boxxsz: Search box (i.e. open area to find) X size         
 ;              Boxysz: Search box Y size                                  
 ;              Movinc: Search box move distance                           
 ;               Lines: 0 = Invisible search pattern                       
 ;                      1 = Draw search marker lines                       
 ;                      2 = Draw search box                                
 ;              Scalfc: Overall scale factor                               
 ;                                                                         
 ;   Note that Areax and Areay will be negative if Pa is at the upper      
 ;   right of the search area.  Boxxsz and Boxysz are always positive,     
 ;   as is Movinc.                                                         
 ;                                                                         
 ;   Feel returns two corners of the free area found, if there is one.     
 ;   Elel can be used to find the lower left corner from this list.        
 ;                                                                         
 ;   The move distance could have been replaced with the number of divs    
 ;   within the search area, but this might have resulted in a suitable    
 ;   area being found which was off snap.  This way the user can specify   
 ;   a subdivision which is on snap if he wants.  If a grain size which    
 ;   results in an equal number of divisions is required then the calling  
 ;   routine can figure it out.                                            
 ;                                                                         
 ;   This subroutine is slow due to the large number of ssget calls.       
 ; 
 (DEFUN FEEL (pa gzero areax areay sdir boxxsz boxysz movinc lines scalfc /
              maxx pax minx xmov pbx maxy pay miny ymov pby orgpax orgpay
                                                  ss orgpbx orgpby pb ook)
 ; Ŀ
 ;   Scale appropriate variables by scale factor and adjust Pa for         
 ;   offset contained in gzero.                                            
 ; 
  (setq pa (list (+ (* scalfc (car pa)) (car gzero))
                 (+ (* scalfc (cadr pa)) (cadr gzero))))
  (setq areax (* areax scalfc))
  (setq areay (* areay scalfc))
  (setq boxxsz (* boxxsz scalfc))
  (setq boxysz (* boxysz scalfc))
  (setq movinc (* movinc scalfc))
 ; Ŀ
 ;   Find the limiting coordinates of the area to be searched, the         
 ;   X and Y increments for search box movement, and the X and Y offsets   
 ;   of the opposite corner of the search box from Pa.                     
 ;   Also save the X and Y coordinates of the start point.                 
 ; 
  (if (minusp areax)
      (progn
           (setq maxx (setq pax (car pa)))    ; maximum search area X value
           (setq minx (+ (car pa) areax))     ; minimum search area X value
           (setq xmov (- movinc))             ; search box X movement
           (setq pbx (- pax boxxsz)))         ; initial search box other corner
      (progn
           (setq minx (setq pax (car pa)))
           (setq maxx (+ (car pa) areax))
           (setq xmov movinc)
           (setq pbx (+ pax boxxsz))))
  (if (minusp areay)
      (progn
           (setq maxy (setq pay (cadr pa)))
           (setq miny (+ (cadr pa) areay))
           (setq ymov (- movinc))
           (setq pby (- pay boxysz)))
      (progn
           (setq miny (setq pay (cadr pa)))
           (setq maxy (+ (cadr pa) areay))
           (setq ymov movinc)
           (setq pby (+ pay boxysz))))
 ; Ŀ
 ;   Save original Pa and Pb X and Y coordinates.                          
 ; 
  (setq orgpax pax)
  (setq orgpay pay)
  (setq orgpbx pbx)
  (setq orgpby pby)
 ; Ŀ
 ;   Now want to check for entities, move the check box, see if the box    
 ;   is still inside the check area.                                       
 ;   Case 1: search first in the X direction.                              
 ;   Move in X dir until outside limits, reset to original X, Y + incr.,   
 ;   start again until Y is outside limits.                                
 ; 
  (while (and (= (strcase sdir) "X")
              (null ook)
              (<= pay maxy) (>= pay miny) (<= pby maxy) (>= pby miny))
         (setq pa (list pax pay))
         (setq pb (list pbx pby))
         (cond ((= lines 1)
                (grdraw pa pb -1))
               ((= lines 2)
                (tiktik pa pb)))
         (command "delay" 4)
         (if (null (setq ss (ssget "C" pa pb)))
             (setq ook T)
             (progn
                  (if (and (<= pax maxx) (>= pax minx)
                           (<= pbx maxx) (>= pbx minx))
                      (progn
                           (setq pax (+ pax xmov))
                           (setq pbx (+ pbx xmov)))
                      (progn
                           (setq pax orgpax)
                           (setq pbx orgpbx)
                           (setq pay (+ pay ymov))
                           (setq pby (+ pby ymov))))))
         (cond ((= lines 1)
                (grdraw pa pb -1))
               ((= lines 2)
                (tiktik pa pb))))
 ; Ŀ
 ;   Case 2: search first in the Y direction.                              
 ;   Move in Y dir until outside limits, reset to original Y, X + incr.,   
 ;   start again until X is outside limits.                                
 ; 
  (while (and (= (strcase sdir) "Y")
              (null ook)
              (<= pax maxx) (>= pax minx) (<= pbx maxx) (>= pbx minx))
         (setq pa (list pax pay))
         (setq pb (list pbx pby))
         (cond ((= lines 1)
                (grdraw pa pb -1))
               ((= lines 2)
                (tiktik pa pb)))
         (if (null (setq ss (ssget "C" pa pb)))
             (setq ook T)
             (progn
                  (if (and (<= pay maxy) (>= pay miny)
                           (<= pby maxy) (>= pby miny))
                      (progn
                           (setq pay (+ pay ymov))
                           (setq pby (+ pby ymov)))
                      (progn
                           (setq pay orgpay)
                           (setq pby orgpby)
                           (setq pax (+ pax xmov))
                           (setq pbx (+ pbx xmov))))))
         (cond ((= lines 1)
                (grdraw pa pb -1))
               ((= lines 2)
                (tiktik pa pb))))
 (if ook (list (list pax pay) (list pbx pby)) ()))
 ; Ŀ
 ;   Feel end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Flip - zooms in to the search area, offsets the search     
 ;   coordinates to allow for a base point which isn't 0,0, inserts the    
 ;   block (if it isn't the same as the current drawing and if there is    
 ;   room) and logs errors to a file.                                      
 ;   The first ten arguments are the same as for Feel.  The last three     
 ;   are the name of the block to insert, and the X and Y offsets of the   
 ;   block insertion point from the lower left point returned by Feel.     
 ; 
 (DEFUN FLIP (pa gzero areax areay sdir boxxsz boxysz movinc lines scalfc
              bloc xofset yofset / boxx boxy)
 ; Ŀ
 ;   First make sure the current drawing isn't the same as the block       
 ;   being inserted.                                                       
 ; 
  (if (= (strcase bloc) (strcase (nopath)))
      (fliperr "Can't insert a block into itself.")
      (progn
 ; Ŀ
 ;   Zoom in to the area being searched.  If the area is too small in      
 ;   relation to the screen area then nearby entities may cause false      
 ;   hits, also searching an area that isn't on the screen gives           
 ;   unpredictable results.  Note that using too large a search area may   
 ;   still cause false hits, besides which it will be slow.                
 ; 
           (zoob pa gzero areax areay scalfc)
 ; Ŀ
 ;   Call Feel to do the actual searching.                                 
 ; 
           (setq corner
                  (feel pa gzero areax areay sdir boxxsz boxysz movinc lines
                                                                     scalfc))
 ; Ŀ
 ;   If a space was found then insert the block.                           
 ; 
           (if corner
               (progn
                    (setq pa (elel corner))
                    (setq pa (list (+ (car pa) (* scalfc xofset))
                                   (+ (cadr pa) (* scalfc yofset))))
                    (command "insert" bloc pa scalfc "" "")))
           (command "zoom" "p")))
 corner)
 ; Ŀ
 ;   Flip end.                                                             
 ; 

 ; Ŀ
 ;   Fliperr - log an error.                                               
 ; 
 (DEFUN FLIPERR (errmsg / dat fn)
  (setq dat (strcat (nopath) ", " errmsg))
  (setq fn (open (strcat (getvar "dwgprefix") "Flip_err.log") "a"))
  (write-line dat fn)
  (close fn)
 (princ))
 ; Ŀ
 ;   Fliperr end.                                                          
 ; 

 ; Ŀ
 ;   Gobo - make current the space occupied by an entity.                  
 ;   Arguments: Enam, the entity name.                                     
 ;   Calls nothing, Returns nothing.                                       
 ; 
 (DEFUN GOBO (enam / ctab)
  (setq ctab (cdr (assoc 410 (entget enam))))
 ; Ŀ
 ;   Set the space containing the entity to be current.                    
 ; 
  (setvar "ctab" ctab)
 ; Ŀ
 ;   If it is not in the Model tab, make sure we are in paper space.       
 ;   (If it is in it it is ok.)                                            
 ; 
  (if (/= (getvar "ctab") "Model") (command ".pspace"))
 (princ))
 ; Ŀ
 ;   Gobo end.                                                             
 ; 

 ; Ŀ
 ;   Layp - see if a layer is off, locked, or frozen.                      
 ;   Takes one argument, a layer name.                                     
 ;   Returns a list of conditions or nil                                   
 ; 
 (DEFUN LAYP (lanam / llist sev col stalst)
  (setq llist (tblsearch "layer" lanam))
  (setq sev (cdr (assoc 70 llist)))
  (setq col (cdr (assoc 62 llist)))
  (if (= (logand sev 1) 1) (setq stalst (list "frozen")))
  (if (= (logand sev 4) 4) (setq stalst (cons "locked" stalst)))
  (if (minusp col) (setq stalst (cons "off" stalst)))
 stalst)
 ; Ŀ
 ;   Layp end.                                                             
 ; 

 ; Ŀ
 ;   Namp - see if can find a tb named in a list.                          
 ;   Arguments: Blist, a list of title block names.                        
 ;   Calls nothing, returns a list: (block_name  ss_thereof).              
 ; 
 (DEFUN NAMP (blist / ss blnam num found)
  (setq num 0)
  (while (and (null found)
              (setq blnam (nth num blist)))
         (setq num (1+ num))
         (if (and (tblsearch "block" blnam)
                  (setq ss (ssget "X" (list (cons 2 blnam)))))
             (setq found t)))
 (list blnam ss))
 ; Ŀ
 ;   Namp end.                                                             
 ; 

 ; Ŀ
 ;   Nopath - returns the drawing name without a path.                     
 ; 
 (DEFUN NOPATH (/ pos tt)
  (setq pos (strlen (setq tt (getvar "dwgname"))))  ; start at end of string
  (while (< 0 pos)
          (if (or (= (substr tt pos 1) (chr 92))    ; if char = \ or
                  (= (substr tt pos 1) ":"))        ;    char = :
             (progn
                   (setq tt (substr tt (1+ pos)))   ; then set tt to all after
                   (setq pos 1)))                   ; and set pos to first
         (setq pos (1- pos)))                       ; decrement pos
 tt)
 ; Ŀ
 ;   Nopath end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Tiktik - draw a temporary box.                             
 ;   Takes two arguments: two corner points.                               
 ; 
 (DEFUN TIKTIK (pa pb / pax pay pbx pby)
  (setq pax (car pa))
  (setq pbx (car pb))
  (setq pay (cadr pa))
  (setq pby (cadr pb))
  (grdraw pa (list pax pby) -1)
  (grdraw (list pax pby) pb -1)
  (grdraw pb (list pbx pay) -1)
  (grdraw (list pbx pay) pa -1))
 ; Ŀ
 ;   Tiktik end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Zoob -  zoom in to a space 10% larger than a search area.  
 ;   Takes three arguments: a corner points and the X and Y dimensions.    
 ; 
 (DEFUN ZOOB (pa gzero xdim ydim scalfc / x1 x2 y1 y2 pax pay)
  (setq xdim (* xdim scalfc))
  (setq ydim (* ydim scalfc))
  (setq pax1 (+ (* scalfc (car pa)) (car gzero)))
  (setq pay1 (+ (* scalfc (cadr pa)) (cadr gzero)))
  (setq xincr (* 0.1 xdim))
  (setq yincr (* 0.1 ydim))
  (setq pax (- pax1 xincr))
  (setq pbx (+ pax1 xincr xdim))
  (setq pay (- pay1 yincr))
  (setq pby (+ pay1 yincr ydim))
  (setq pa (list pax pay))
  (setq pb (list pbx pby))
  (command "zoom" pa pb))
 ; Ŀ
 ;   Zoob end.                                                             
 ; 

 ; Ŀ
 ;   Flipper - the helpful cetacean.                                       
 ; 
 (DEFUN C:FLIPPER (/ dimscl pa corner gzero insok)
  (setvar "cmdecho" 0)
  (command "undo" "be")
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
  (setq dimscl (misps))
 ; Ŀ
 ;   Make layer 0 current if it's ready to use.                            
 ; 
  (if (null (layp "0"))
      (setvar "clayer" "0""))
 ; Ŀ
 ;   Find the title block (call namp) and get its insertion point.         
 ;   This is used as the base point from which Pa is taken to be an        
 ;   offset, not all drawings having been inserted at 0,0.                 
 ;   Note that no attempt is made to check for multiple title blocks,      
 ;   if they aren't immediately apparent they are probably right on top    
 ;   of each other anyway.                                                 
 ; 
  (if (setq ss (cadr (namp (list "PPC-Dsize"))))
      (progn
           (setq enam (ssname ss 0))
           (setq gzero (cdr (assoc 10 (entget enam)))))
      (fliperr "Title block not found."))
 ; Ŀ
 ;   Now call Flip to do the work.                                         
 ; 
  (if gzero
      (progn
 ; Ŀ
 ;   Go to the space containing the title block.                           
 ; 
           (gobo enam)
 ; Ŀ
 ;   Call Flip to try to insert the tridyne logo block.                    
 ;   Arguments:     Pa: Search start point                                 
 ;               Gzero: base point (i.e. tb insertion point)               
 ;                      from which pa is an offset                         
 ;               Areax: Search area X width (+ or -)                       
 ;               Areay: Search area Y height (+ or -)                      
 ;                Sdir: Move search box first in X or Y direction          
 ;              Boxxsz: Search box (i.e. open area to find) X size         
 ;              Boxysz: Search box Y size                                  
 ;              Movinc: Search box move distance                           
 ;               Lines: 0 = Invisible search pattern                       
 ;                      1 = Draw search marker lines                       
 ;                      2 = Draw search box                                
 ;              Scalfc: Overall scale factor                               
 ;                Bloc: the name of the block to insert                    
 ;   Xofset and Yofset: the X and Y offsets of the block insertion point   
 ;                      from the lower left point returned by Feel.        
 ; 
  ;         (setq insok (flip (list 820 47.5) gzero -810 40 "X" 110 25 2.5 2
  ;                            dimscl "tridyne-logo" 2.5 2.5))
  ;         (if (null insok)
  ;            (setq insok (flip (list 820 47.5) gzero -165 203 "X" 110 25 2.5
  ;                              2 dimscl "tridyne-logo" 2.5 2.5)))
  ;         (if (null insok)
  ;             (progn
  ;                  (command "insert" "tridyne-logo"
  ;                           (polar (polar gzero 0 712.5) (/ pi 2) 50)
  ;                            dimscl "" "0")
  ;                  (fliperr "Logo block arbitrarily inserted.")))
  ;         (gc)
 ; Ŀ
 ;   And the stamp block.                                                  
 ; 
           (setq insok (flip (list 820 47.5) gzero -807.5 82.5 "X" 125 55 2.5
                             2 dimscl "tridyne stamps" 2.5 2.5))
           (if (null insok)
               (progn
                    (command "insert" "tridyne stamps"
                             (polar (polar gzero 0 697.5) (/ pi 2) 75)
                              dimscl "" "0")
                    (fliperr "Stamp and permit block arbitrarily inserted.")))
           (gc)))
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (command "undo" "end") 
 (princ))